//Source file: H:\MIDDLEWARE\SRC\ALKINDI\BUSINESSSERVICES\UTIL\PROPERTYMANAGER.JAVA

package Alkindi.Services.Util;

import javax.naming.InitialContext;
import javax.naming.Context;
import javax.naming.NamingException;
import java.io.FileInputStream;
import Alkindi.Services.AlkExcept;

/* 
$Header: PropertyManager.java, 8, 2/5/01 3:07:59 PM, Schwartz, Joe$
$Log: 
 8    Alkindi Development1.7         2/5/01 3:07:59 PM    Schwartz, Joe   Fixed
      erroneous error message.
 7    Alkindi Development1.6         1/22/01 6:39:08 PM   Schwartz, Joe   Added
      getFloat().
 6    Alkindi Development1.5         12/28/00 1:07:27 PM  Schwartz, Joe   Added
      Version Control header info.
 5    Alkindi Development1.4         12/26/00 6:57:14 PM  Schwartz, Joe   
 4    Alkindi Development1.3         12/26/00 5:36:59 PM  Schwartz, Joe   
 3    Alkindi Development1.2         12/20/00 5:44:43 PM  Schwartz, Joe   
 2    Alkindi Development1.1         12/18/00 12:05:38 PM Schwartz, Joe   Moved
      internal data classes to Utils package & regenerated classes from Rose.
 1    Alkindi Development1.0         11/8/00 2:58:50 PM   Schwartz, Joe   
$
$NoKeywords$
 */

/**
 * Manages the access of Alkindi Middleware properties for the server components. This class performs JNDI lookups of the environment properties of the current context. When called from within an EJB, the properties are the <env-entry> elements specified in the ejb-jar.xml deployment descriptor for that bean.
 * The methods are all declared as <b>static final</b> in order to speed processing.
 */
public class PropertyManager 
{
	private static final String cName = "PropMgr";
	
	static 
	{
	}
	
	/**
	 * Returns the named property as a boolean
	 * @param propName the name of the property to return
	 * @return boolean
	 * @throws AlkExcept
	 * @roseuid 3A490E1F005D
	 */
	public static final boolean getBool(final java.lang.String propName) throws AlkExcept 
	{
		final String mName = "getBool";
		Object envObj = null;
		try {
			envObj = lookup(propName);
		}
		catch (NamingException ne) {
			throw new AlkExcept("Could not find environment property " + propName + ":\n" + ne.getExplanation(), 2702);
			
		}
		if (envObj instanceof Boolean) {
			return ((Boolean)envObj).booleanValue();
		}
		else {
			throw new AlkExcept("Error: enviroment property " + propName + " was wrong type (expected Boolean).", 2702);
		}
	}
	
	/**
	 * Returns the named property as a double.
	 * @param propName the name of the property to return
	 * @return double
	 * @throws AlkExcept
	 * @roseuid 3A40CFFC009C
	 */
	public static final double getDouble(final java.lang.String propName) throws AlkExcept 
	{
		final String mName = "getDouble";
		Object envObj = null;
		try {
			envObj = lookup(propName);
		}
		catch (NamingException ne) {
			throw new AlkExcept("Could not find environment property " + propName + ":\n" + ne.getExplanation(), 2701);
			
		}
		if (envObj instanceof Double) {
			return ((Double)envObj).doubleValue();
		}
		else {
			throw new AlkExcept("Error: enviroment property " + propName + " was wrong type (expected Double).", 2701);
		}
	}
	
	/**
	 * Returns the named property as a float
	 * @param propName the name of the property to return
	 * @return float
	 * @throws AlkExcept
	 * @roseuid 3A6CB4F2005D
	 */
	public static final float getFloat(final java.lang.String propName) throws AlkExcept 
	{
		final String mName = "getFloat";
		Object envObj = null;
		try {
			envObj = lookup(propName);
		}
		catch (NamingException ne) {
			throw new AlkExcept("Could not find environment property " + propName + ":\n" + ne.getExplanation(), 2704);
			
		}
		if (envObj instanceof Float) {
			return ((Float)envObj).floatValue();
		}
		else {
			throw new AlkExcept("Error: enviroment property " + propName + " was wrong type (expected Float).", 2704);
		}
	}
	
	/**
	 * Returns the named property as an int.
	 * @param propName the name of the property to return
	 * @return int
	 * @throws AlkExcept
	 * @roseuid 3A40CFEC0251
	 */
	public static final int getInt(final java.lang.String propName) throws AlkExcept 
	{
		final String mName = "getInt";
		Object envObj = null;
		try {
			envObj = lookup(propName);
		}
		catch (NamingException ne) {
			throw new AlkExcept("Could not find environment property " + propName + ":\n" + ne.getExplanation(), 2702);
			
		}
		if (envObj instanceof Integer) {
			return ((Integer)envObj).intValue();
		}
		else {
			throw new AlkExcept("Error: enviroment property " + propName + " was wrong type (expected Integer).", 2702);
		}
	}
	
	/**
	 * Returns the named property as a long.
	 * @param propName the name of the property to return
	 * @return long
	 * @throws AlkExcept
	 * @roseuid 3A40D03001A5
	 */
	public static final long getLong(final java.lang.String propName) throws AlkExcept 
	{
		Object envObj = null;
		try {
			envObj = lookup(propName);
		}
		catch (NamingException ne) {
			throw new AlkExcept("Could not find environment property " + propName + ":\n" + ne.getExplanation(), 2702);
			
		}
		if (envObj instanceof Long) {
			return ((Integer)envObj).longValue();
		}
		else {
			throw new AlkExcept("Error: enviroment property " + propName + " was wrong type (expected Long).", 2702);
		}
	}
	
	/**
	 * Returns the named property as a String.
	 * @param propName the name of the environment property to return
	 * @return String
	 * @throws AlkExcept
	 * @roseuid 3A0960C2002E
	 */
	public static final String getString(final String propName) throws AlkExcept 
	{
		final String mName = "getString";
		Object envObj = null;
		try {
			envObj = lookup(propName);
		}
		catch (NamingException ne) {
			throw new AlkExcept("Could not find environment property " + propName + ":\n" + ne.getExplanation(), 2702);
			
		}
		if (envObj instanceof String) {
			return (String)envObj;
		}
		else {
			throw new AlkExcept("Error: enviroment property " + propName + " was wrong type (expected String).", 2702);
		}
	}
	
	/**
	 * @roseuid 3A48E8990148
	 */
	private static final java.lang.Object lookup(final java.lang.String objName) throws NamingException 
	{
		Context ctx = new InitialContext();
		return ctx.lookup("java:comp/env/" + objName);
	}
}
